<?php
function debug($arr){
	echo '<pre>';
	print_r($arr);
	echo '</pre>';
	exit();
}
class Api{
	private $cook = array();
	private $headers = array(
	'Origin: https://www.icloud.com ',
	'User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36 ',
	'Content-Type: text/plain ',
	'Accept: */*',
	'Referer: https://www.icloud.com/ ',
	// 'Accept-Encoding: gzip, deflate ',
	'Accept-Language: en-US,en;q=0.8 ',
	);
	private $username="";
	private $password="";
	private $server;
	private $devices_list= array(
		'device_list'=>array()
	);

	private $owner_apple_id="";
	private $owner_name="";
	
    private $logFile = __DIR__ . '/app.log';  // Archivo de log

	private function writeLog(string $mensaje, string $nivel = 'INFO')
	{
		$fecha = date('Y-m-d H:i:s');
		$entrada = "[$fecha] [$nivel] $mensaje" . PHP_EOL;
		file_put_contents($this->logFile, $entrada, FILE_APPEND | LOCK_EX);
	}
	
	private function Login($user, $pass)
	{
		$this->username = $user;
		$this->password = $pass;
	
		// Obtener el WebAuthToken
		$webAuthToken = $this->get_web_auth_token($user, $pass);
		if ($webAuthToken == false) {
			$this->writeLog("ERROR: No se pudo obtener el WebAuthToken para el usuario: $user");
			return false;
		}
	
		while (true) {
			$url = "https://setup.icloud.com/setup/ws/1/accountLogin";
			$data = '{"dsWebAuthToken":"' . $webAuthToken . '","extended_login":false}';
			$response = $this->get_url_response($url, $data, $this->headers, 'POST');
	
			$result = $response[2];
			$result_with_headers = $response[0];
	
			$first = json_decode($result, true);
	
			if (isset($first["error"])) {
				return false;
			} elseif (isset($first["domainToUse"])) {
				$domain = strtolower($first["domainToUse"]);
				$this->headers[0] = "Origin: https://www.$domain";
				continue;  // Reintentar con el nuevo dominio
			} else {
				$this->owner_apple_id = $first['dsInfo']['appleId'];
				$this->owner_name = $first['dsInfo']['fullName'];
	
				$this->server = $first["webservices"]["findme"]["url"];
				$this->headers[6] = "Cookie: " . $this->saveCookie($result_with_headers);
				return true;
			}
		}
	}
	
	private function get_web_auth_token($user, $pass)
	{
		$this->writeLog("INICIO: Solicitud para obtener WebAuthToken para el usuario: $user");

		// URL de autenticación
		$url = 'https://idmsa.apple.com/appleauth/auth/signin?widgetKey=d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d';

		// Encabezados para la solicitud
		$headers = [
			"Host: idmsa.apple.com",
			"Connection: keep-alive",
			'Sec-CH-UA: "Not)A;Brand";v="99", "Google Chrome";v="127", "Chromium";v="127"',
			"SCNT: AAAA-jhGODc2Rjk2RTYzQUVFNjJGQ0VENDlCNDAwMEY2ODEwOEExODMwQTM5ODJBNzBCQkIwRERFMEUxRTc5Qzg1MURBQkY3NDM0MzczREQ1RDFFRTRERTAyOUUyODk2QzU3NTYwNTZBQ0NCRkIzODI1MkIzRDJCMjM5NTY1MDZBOTZGNTI2REU4Qzg1ODM2MzdFMDcxNUI1NEYyQjEzQkYxMjFBOUJDQjc0Qjg3ODc5MkQzN0JDRDI4MDA0QjUzREZFRjk3NjlFRkUyQzY4OTUzRjEzMEI4MjQ5NjA3QjdDQ0NEOTRCRTFFQTdFRTFBQTkwM3wxAAABkaUguXe6ve9hUCGj4YCZgwLCi-TRegfSqkNDRqpRKWOxlZ8B3xIxCM1JnJwwADJUrCNPxo87sniojgEE_suphxGXX3eyVWhRMeQtwnWahJaP_QeV2Q",
			"X-Apple-Widget-Key: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
			"X-Apple-Frame-Id: 098904f5-3296-4d6c-899f-a3b99120c159",
			"X-Apple-I-FD-Client-Info: {\"U\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36\",\"L\":\"es-419\",\"Z\":\"GMT-06:00\",\"V\":\"1.1\",\"F\":\"kla44j1e3NlY5BNlY5BSs5uQ084akLKGcI4v9W79jV0R0odm_dhrxbuJjkWxv55BPQd.ka4YeRa3tJ9VvjHzWBzK2vqBBNlY5BPY25BNnOVgw24uy.9IZ\"}",
			"X-Requested-With: XMLHttpRequest",
			"Sec-CH-UA-Platform: Windows",
			"X-Apple-Crauth-Required: true",
			"X-Apple-Auth-Attributes: PEplvzpN2QqETxsYVKBiADJWRuWHeD0=",
			"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
			"X-Apple-Locale: es_MX",
			"Content-Type: application/json",
			"Accept: application/json, text/javascript, */*; q=0.01",
			"X-Apple-Offer-Security-Upgrade: 0",
			"X-Apple-Domain-Id: 3",
			"Origin: https://idmsa.apple.com",
			"Sec-Fetch-Site: same-origin",
			"Sec-Fetch-Mode: cors",
			"Sec-Fetch-Dest: empty",
			"Referer: https://idmsa.apple.com/",
			"Accept-Encoding: */*",
			"Accept-Language: es-419,es;q=0.9"
		];

		// Datos del cuerpo de la solicitud
		$body = [
			'accountName' => $user,  // Aquí utilizamos el usuario pasado como parámetro
			'password' => $pass,     // Aquí utilizamos la contraseña pasada como parámetro
			'rememberMe' => true,
			'skip2FA' => false,
			'trustTokens' => [],
			'pause2FA' => true
		];

		$this->writeLog("ENTRADA: Realizando solicitud para obtener el WebAuthToken... " . json_encode($body));

		// Iniciar la sesión cURL
		$ch = curl_init();

		// Configurar cURL
		curl_setopt_array($ch, [
			CURLOPT_URL => $url,
			CURLOPT_POST => true,
			CURLOPT_HTTPHEADER => $headers,
			CURLOPT_POSTFIELDS => json_encode($body),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_HEADER => true,
			CURLOPT_ENCODING => '',
		]);

		// Ejecutar la solicitud
		$response = curl_exec($ch);

		// Verificar si hubo error en la ejecución
		if ($response === false) {
			curl_close($ch);
			$this->writeLog("ERROR: No se pudo obtener WebAuthToken para el usuario: $user");
			return null;
		}

		// Obtener los encabezados de la respuesta
		$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$headersResponse = substr($response, 0, $headerSize);

		// Cerrar la sesión cURL
		curl_close($ch);

		// Buscar el token de sesión de Apple
		if (preg_match('/^X-Apple-Session-Token:\s*(.+)$/mi', $headersResponse, $matches)) {
			$this->getWebAuthToken = trim($matches[1]);
			$this->writeLog("SALIDA: WebAuthToken obtenido correctamente para el usuario: " . trim($matches[1]));

			return trim($matches[1]);
		}

		// Si no se encuentra el token, retornar null
		$this->writeLog("ERROR: No se encontró WebAuthToken para el usuario: $user");
		return null;
	}


	public function start_remove($username, $password,$autoremove){
		
		$this->username = $username;
		$this->password = $password;

		if(!$this->Login($this->username,$this->password)){
			return array('success' => false, 'msg'=>'Invalid username or password.');
		}
		
		if($autoremove==false){
			$this->devices_list['success'] = true;
			$this->devices_list['id'] = $this->username;
			$this->devices_list['pwd'] = $this->password;
			$this->devices_list['device_list'] = array();
			$this->devices_list['autoremove'] = $autoremove;
			return $this->devices_list;
		}
		
		$url = $this->server."/fmipservice/client/web/initClient";
		$response = $this->get_url_response($url,'{"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","apiVersion":"3.0","deviceListVersion":1,"fmly":true,"timezone":"US/Pacific","inactiveTime":348}}',$this->headers,'POST');
		
		$result = $response[2];
		$result = json_decode($result);
		$devices = $result->content;
		
		$serverContext = json_encode($result->serverContext);
		$details = $this->GetDetails();
		
		foreach($devices as $device){
			//if($device->deviceStatus ==201){
				$id = $device->id;
				$name = $device->name;
				$deviceDisplayName = $device->deviceDisplayName;
				$passcodeLength = $device->passcodeLength;
				$activationLocked  = $device->activationLocked;
				$deviceClass = $device->deviceClass;
				$rawDeviceModel = $device->rawDeviceModel;
				$lostModeEnabled = $device->lostModeEnabled;
				
				
				$url = $this->server."/fmipservice/client/web/remove";
				
				$authentication_token = $this->Auth($id,$serverContext);
				$data = '{"authToken":"'.$authentication_token.'","device":"'.$id.'","serverContext":'.$serverContext.',"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","timezone":"Asia/Shanghai","inactiveTime":1612,"apiVersion":"3.0","deviceListVersion":1,"fmly":true}}';
				
				$response = $this->get_url_response($url,$data,$this->headers,'POST');
				$result = $response[2];
				$result = json_decode($result);
				
				$remove_result=array(
					'id'=>$id,
					'model'=>$deviceDisplayName,
					'device_name'=>$name,
					'device_type'=>$deviceClass,
					'raw_device_model'=>$rawDeviceModel,
					'passcode_length'=>$passcodeLength ,
					'activation_locked'=>($activationLocked ? 'Yes' : 'No'),
					'lost_mode'=>($lostModeEnabled ? 'Yes' : 'No'),
					'owner_name'=>$this->owner_name,
					'owner_appleid'=>$this->owner_apple_id,
					'owner_number'=>(isset($device->lostDevice->ownerNbr) ? $device->lostDevice->ownerNbr : ""),
					'owner_lostmode_msg'=>(isset($device->lostDevice->text) ? $device->lostDevice->text  : ""),
					'owner_lostmode_email'=>(isset($device->lostDevice->email) ? $device->lostDevice->email : ""),
					'msg'=>($result->statusCode == "200" ? 'Removed' : 'Failed'),
					'status'=>$result->statusCode,
				);
				
				array_push($this->devices_list['device_list'],$remove_result);
			//}
		}
		
		$this->devices_list['id'] = $this->username;
		$this->devices_list['pwd'] = $this->password;
		$this->devices_list['success'] = true;
		$this->devices_list['autoremove'] = $autoremove;
		//check removed devices
		//$this->devices_list = $this->check_removed($this->devices_list);
		
		return $this->devices_list;
	}
	
	
	private function check_removed($devices_list){
		$url = $this->server."/fmipservice/client/web/initClient";
		$response = $this->get_url_response($url,'{"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","apiVersion":"3.0","deviceListVersion":1,"fmly":true,"timezone":"US/Pacific","inactiveTime":348}}',$this->headers,'POST');
		$result = $response[2];
		$result = json_decode($result);
		$devices = $result->content;
		
		foreach($devices as $device){
			if(isset($devices_list['device_list']) && count($devices_list['device_list']) >=1){
				$id = $device->id;
				$found_key = array_search($id, array_column($devices_list['device_list'], 'id'));
				if(trim($found_key) !== null && trim($found_key) !==''){
					$devices_list['device_list'][$found_key]['msg'] = 'Failed';
				}
			}
		}
		
		return $devices_list;
	}
	

	private function GetDetails(){
		$url = "https://p38-setup.icloud.com/setup/web/device/getDevices?";
		$response = $this->get_url_response($url,"",$this->headers,'POST');
		$response = json_decode($response[2]);
		return $response->devices;
	}

	private function Auth($id=null,$serverContext=null){
		$url = $this->server."/fmipservice/client/web/authForUserDevice";
		$data = '{"authToken":"'.$this->password.'","device":"'.$id.'","serverContext":'.$serverContext.',"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","timezone":"Asia/Shanghai","inactiveTime":1612,"apiVersion":"3.0","deviceListVersion":1,"fmly":true}}';
		$response = $this->get_url_response($url,$data,$this->headers,'POST');
		$result = $response[2];
		$result = json_decode($result);

		return $result->authToken;
	}
	
	private function get_url_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_POST,true);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body);
	}
	
	private function saveCookie($result_with_headers){
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("Set-Cookie: ","",$value);
			$cookies .= $value."; ";
			
			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
		return $cookies;
	}
	
	private function getHeaders($response) { 
		$headers = array(); 
		$header_text = substr($response, 0, strpos($response, "\r\n\r\n")); 
		foreach (explode("\r\n", $header_text) as $i => $line) 
			 if ($i === 0) ; 
			 else { 
				  list ($key, $value) = explode(': ', $line); $header_key = str_replace(' ', '_', strtolower($key)); $headers[$header_key] = "$key: $value"; 
			 } 
		return $headers; 
	}
	
	
	
	
}
?>