<?php
class Api{
	public $components = array(
		'DaiSharedFunction',
		'Auth' => array(
		  'authenticate' => array(
			'Basic'
		  ),
		  'authError' => 'You may not access this area.',
		)
	);
	
	private $cook = array();
	private $headers = array(
	'Origin: https://www.icloud.com ',
	'User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36 ',
	'Content-Type: text/plain ',
	'Accept: */*',
	'Referer: https://www.icloud.com/ ',
	'Accept-Encoding: gzip, deflate ',
	'Accept-Language: en-US,en;q=0.8 ',
	);
	public $username="";
	public $password="";
	private $server;
	private $authToken="";
	private $devices_list= array(
		'device_list'=>array()
	);
	
	private $owner_apple_id="";
	private $owner_name="";
	
	private function Login($user , $pass){
		$this->username = $user;
		$this->password = $pass;
		$url = "https://setup.icloud.com/setup/ws/1/login";
		$data = '{"apple_id":"'.$this->username.'","password":"'.$this->password.'","extended_login":false}';
		
		//new
		$data = $this->execute_js($user , $pass);
		//end
		
		$response = $this->Post($url,$data);

		$result = $response[0];
		$result_with_headers = $response[1];

		$first = json_decode($result, true);

		if(isset($first["error"])){
			return false;	
		}else{
			$this->owner_apple_id = $first['dsInfo']['appleId'];
			$this->owner_name = $first['dsInfo']['fullName'];
			
			$this->server = $first["webservices"]["findme"]["url"];
			//Geth the cookies
			preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
			$cookies = "";
			foreach($matches[0] as $value){
				$value = str_replace("Set-Cookie: ","",$value);
				$cookies .= $value."; ";
				
				$h = explode("=", $value);
				$v = str_replace($h[0]."=","",$value);
				$this->cook[$h[0]]=$v;	
			}
			//Get list
			$this->headers[6] = "Cookie: ".$cookies;
			return true;
		}	
	}
	
	
	private function initLogin($user , $pass){
		$this->username = $user;
		$this->password = $pass;
		$url = 'https://setup.icloud.com/setup/fmipauthenticate/$APPLE_ID$';
		$auth = "$user:$pass";
		$ua = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36';
		
		$headers = array(
			'Content-Type: text/plist',
			'Accept: */*',
		);
		
		$response = $this->get_web_response($url,'',$headers,'POST',$ua,$auth);

		if($response[1]==200){
			return true;
		}else{
			return false;
		}
	}


	public function Delete_All(){

		if(!$this->initLogin($this->username,$this->password)){
			return array('success' => false, 'msg'=>'Invalid username or password.');
		}
		
		if(!$this->Login($this->username,$this->password)){
			return array('success' => false, 'msg'=>'Invalid username or password.');
		}
		
		$url = $this->server."/fmipservice/client/web/refreshClient";
		$response = $this->Post($url,"");
		$result = $response[0];
		$result = json_decode($result);
		$devices = $result->content;
		
		$this->saveCookie($response);
		$cookies ="";
		foreach($this->cook as $key=>$value){
			$cookies .= $key.'='.$value."; ";
		}
		$this->headers[6] = "Cookie: ".$cookies;

		$serverContext = json_encode($result->serverContext);
		$details = $this->GetDetails();
		// debug($devices);exit();
		foreach($devices as $device){
			//if($device->deviceStatus ==201){
				$id = $device->id;
				$auths = $this->Auth($id,$serverContext);
				
				$name = $device->name;
				$deviceDisplayName = $device->deviceDisplayName;
				$passcodeLength = $device->passcodeLength;
				$activationLocked  = $device->activationLocked;
				$deviceClass = $device->deviceClass;
				$rawDeviceModel = $device->rawDeviceModel;
				$lostModeEnabled = $device->lostModeEnabled;
				
				
				$url = $this->server."/fmipservice/client/web/remove";
				$data = '{"authToken":"'.$this->authToken.'","device":"'.$id.'","serverContext":'.$serverContext.',"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","timezone":"Asia/Shanghai","inactiveTime":1612,"apiVersion":"3.0","deviceListVersion":1,"fmly":true}}';
				$response = $this->Post($url,$data);
				$result = $response[0];
				$result = json_decode($result);
				
				$remove_result=array(
					'id'=>$id,
					'model'=>$deviceDisplayName,
					'device_name'=>$name,
					'device_type'=>$deviceClass,
					'raw_device_model'=>$rawDeviceModel,
					'passcode_length'=>$passcodeLength ,
					'activation_locked'=>($activationLocked ? 'Yes' : 'No'),
					'lost_mode'=>($lostModeEnabled ? 'Yes' : 'No'),
					'owner_name'=>$this->owner_name,
					'owner_appleid'=>$this->owner_apple_id,
					'owner_number'=>(isset($device->lostDevice->ownerNbr) ? $device->lostDevice->ownerNbr : ""),
					'owner_lostmode_msg'=>(isset($device->lostDevice->text) ? $device->lostDevice->text  : ""),
					'owner_lostmode_email'=>(isset($device->lostDevice->email) ? $device->lostDevice->email : ""),
					'msg'=>($result->statusCode == "200" ? 'Removed' : 'Failed'),
					'status'=>$result->statusCode,
				);
				
				array_push($this->devices_list['device_list'],$remove_result);
			//}
		}
		
		$this->devices_list['id'] = $this->username;
		$this->devices_list['pwd'] = $this->password;
		$this->devices_list['success'] = true;
		
		//check removed devices
		$this->devices_list = $this->check_removed($this->devices_list);
		
		return $this->devices_list;
	}
	
	
	private function check_removed($devices_list){
		$url = $this->server."/fmipservice/client/web/refreshClient";
		$response = $this->Post($url,"");
		$result = $response[0];
		$result = json_decode($result);
		$devices = $result->content;
		
		foreach($devices as $device){
			if(isset($devices_list['device_list']) && count($devices_list['device_list']) >=1){
				$id = $device->id;
				$found_key = array_search($id, array_column($devices_list['device_list'], 'id'));
				if(trim($found_key) !== null && trim($found_key) !==''){
					$devices_list['device_list'][$found_key]['msg'] = 'Failed';
				}
			}
		}
		
		return $devices_list;
	}
	

	private function GetDetails(){
		$url = "https://p38-setup.icloud.com/setup/web/device/getDevices?";
		$response = $this->Post($url,"");
		$response = json_decode($response[0]);
		return $response->devices;
	}

	private function Auth($id=null,$serverContext=null){
		$url = $this->server."/fmipservice/client/web/authForUserDevice";
		$data = '{"authToken":"'.$this->password.'","device":"'.$id.'","serverContext":'.$serverContext.',"clientContext":{"appName":"iCloud Find (Web)","appVersion":"2.0","timezone":"Asia/Shanghai","inactiveTime":1612,"apiVersion":"3.0","deviceListVersion":1,"fmly":true}}';
		$response = $this->Post($url,$data);
		$result = $response[0];
		$result = json_decode($result);
		
		$this->saveCookie($response);
		$cookies ="";
		foreach($this->cook as $key=>$value){
			$cookies .= $key.'='.$value."; ";
		}
		$this->headers[6] = "Cookie: ".$cookies;
		$this->authToken = $result->authToken;
		return $response;
	}
	
	private function execute_js($user , $pass){
		$descriptorspec = array(
			0 => array("pipe", "r"), // stdin
			1 => array("pipe", "w"), // stdout
			2 => array("pipe", "w"), // stderr
		);

		// Replace this with the actual path to node executable
		$arguments = [$user , $pass];
		$command = "node nodes/apple.js " . escapeshellarg($arguments[0]) . " " . escapeshellarg($arguments[1]);
		$process = proc_open($command, $descriptorspec, $pipes);

		if (is_resource($process)) {
			fclose($pipes[0]); // close stdin

			$output = stream_get_contents($pipes[1]); // read stdout
			fclose($pipes[1]);

			$errorOutput = stream_get_contents($pipes[2]); // read stderr
			fclose($pipes[2]);

			$returnValue = proc_close($process); // close process

			if (!empty($errorOutput)) {
				return false;
			}else{
				return $output;
			}
		}
	}

	private function Post($url,$data){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_POST,true);
		//curl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8080');
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);
		$result = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		return array($result,$result_with_headers,$httpcode);
	}
	
	private function get_web_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		$redirectURL = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL );
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body,$redirectURL);
	}
	
	private function saveCookie($response){
		$result_with_headers = $response[1];
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("Set-Cookie: ","",$value);
			$cookies .= $value."; ";
			
			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
	}
	
	
}
?>