<?php
class Api{
	private $username="";
	private $password="";
	
	private $cook = array();
	private $default_ua = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0";
	private $headers = array(
		'ua'=>'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0',
		'origin'=>'Origin: https://id5.cloud.huawei.com',
		'content'=>'Content-Type: application/x-www-form-urlencoded',
	);
	
	private $devices_list= array(
		'device_list'=>array()
	);
	
	public function start_remove($username, $password,$autoremove){
		
		$this->username = $username;
		$this->password = $password;
		
		if($this->login($this->username,$this->password)){
			
			if($autoremove){
				$this->remove_all_device();
			}
			
			$this->devices_list['success'] = true;
			$this->devices_list['id'] = $this->username;
			$this->devices_list['pwd'] = $this->password;
			$this->devices_list['device_list'] = array_values($this->devices_list['device_list']);
			$this->devices_list['autoremove'] = $autoremove;
			
			return $this->devices_list;
			
		}else{
			echo '{"success":false,"msg": "Invalid username or password."}';
			exit();
		}
	}
	
	private function remove_all_device(){
		return true;
	}
	
	private function login($username,$password){
		
		
		$login_params = $this->get_page_token();
		if($login_params == false){
			echo '{"success":false,"msg": "Failed to generate login token!"}';
			exit();
		}
		
		$pageToken = $login_params[0];
		$pageTokenKey = $login_params[1];
		$logID = $login_params[2];
		
		$url = 'https://id5.cloud.huawei.com/CAS/IDM_W/ajaxHandler/remoteLogin?reflushCode=0.5625938816582539&cVersion=UP_CAS_6.12.0.100_live';
		$data = array(
			'pageToken' => $pageToken,
			'pageTokenKey' => $pageTokenKey,
			'reqClientType' => 1,
			'loginChannel' => '1000002',
			'clientID' => '4805300',
			'lang' => 'en-us',
			'languageCode' => 'en-us',
			'loginUrl' => 'https://cloud.huawei.com:443/wapFindPhone?timestamp:1701220612117',
			'service' => 'https://cloud.huawei.com:443/wapFindPhone?timestamp:1701220612117',
			'quickAuth' => false,
			'isThirdBind' => 0,
			'hwmeta' => '',
			'lowLogin' => true,
			'userAccount' => $username,
			'password' => $password,
			'scope' => 'https://www.huawei.com/auth/account/pwdlowlogin',
		);
		
		$data = http_build_query($data);
		
		$response = $this->get_web_response($url,$data,$this->headers,'POST',$this->default_ua);
		$response_body = json_decode($response[2],true);
		
		$is_success = $response_body['isSuccess'] ?? false;
		
		if($is_success){

			//save login cookie
			$cookies = $this->saveCookie($response);
			$this->headers['cookie'] = "Cookie: ".$cookies;
		
			return true;
		}else{
			$error = $response_body['errorDesc'] ?? '{"errorDesc":"Account or password error."}';
			$error = json_decode($error,true);
			
			if(is_array($error)){
				$error = $error['errorDesc'];
			}else{
				$error = $response_body['errorDesc'];
			}
			
			echo '{"success":false,"msg": "'.$error.'"}';
			exit();
			
			return false;
		}
	}

	private function get_page_token(){
		$url = 'https://id5.cloud.huawei.com/CAS/IDM_W/ajaxHandler/login/getPageInfo?reflushCode=0.7308933968834748&cVersion=UP_CAS_6.12.0.100_live';
		
		$response = $this->get_web_response($url,'pageName=login',$this->headers,'POST',$this->default_ua);
		$response_body = $response[2];

		$cookies = $this->saveCookie($response);
		$this->headers['cookie'] = "Cookie: ".$cookies;
		
		$response_body = json_decode($response_body, true);
		
		$is_success = $response_body['isSuccess'] ?? false;
		
		if($is_success){
			return array($response_body['pageToken'],$response_body['pageTokenKey'],$response_body['logID']);
		}else{
			return $is_success;
		}
	}
	
	private function saveCookie($response){
		$result_with_headers = $response[0];
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("Set-Cookie: ","",$value);
			$cookies .= $value."; ";

			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
		return $cookies;
	}
	
	private function getHeaders($response) { 
		$headers = array(); 
		$header_text = substr($response, 0, strpos($response, "\r\n\r\n")); 
		foreach (explode("\r\n", $header_text) as $i => $line) 
			 if ($i === 0) ; 
			 else { 
				  list ($key, $value) = explode(': ', $line); $header_key = Inflector::underscore($key); $headers[$header_key] = "$key: $value"; 
			 } 
		return $headers; 
	}
	
	private function get_web_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		$redirectURL = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL );
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body,$redirectURL);
	}

}
?>