<?php
class API {
	private $cook = array();
	private $headers = array(
		'User-Agent: Mozilla/5.0 (iPhone; CPU iPhone OS 16_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/113.0.5672.121 Mobile/15E148 Safari/604.1',
	);
	private $username="";
	private $password="";
	
	private $ssecurity="";
	private $nonce = "";
	private $serviceToken = "";

	private $devices_list= array(
		'device_list'=>array()
	);
	
	private function get_sign() {
		$output = $this->GET("https://account.xiaomi.com/pass/serviceLogin?sid=".$this->_sid."&_json=true");
		preg_match('/_sign":"(.*?)"/', $output, $matches, PREG_OFFSET_CAPTURE);
		if (!isset($matches[1])) {
			return '';
		}
		return $matches[1][0];
	}
	
	private function Login($user , $pass){
		$this->username = $user;
		$this->password = $pass;
		
		$user_data_arr = $this->encrypt($user);
		// $user = $user_data_arr[0];
		
		$cookies = "";
		$response = $this->GET2('https://account.xiaomi.com/pass/serviceLogin?sid=i.mi.com&_json=true');
		$auth_arr = str_replace("&&&START&&&","",$response[0]);
		$auth_arr = json_decode($auth_arr,true);
		
		//prepare header
		$this->headers[1] = "Cookie: ".$this->saveCookie($response);
		$deviceId = $this->cook['deviceId'] ?? '';
		$this->headers[2] = 'serviceParam: {"checkSafePhone":false,"checkSafeAddress":false,"lsrp_score":0.0}';
		$this->headers[3] = 'EUI: '.$user_data_arr[1];
		$this->headers[4] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
		
		//prepare data
		
		
		$callback = "";
		if($auth_arr['sid']=="i.mi.com"){
			$callback = "https://i.mi.com/sts?sign=pap02TbDXsaPNAR3KsVCAVnjdjI=&followup=https://i.mi.com/mobile/find&sid=".$auth_arr['sid'];
		}else{
			$callback = "https://account.xiaomi.com/sts?sign=ZvAtJIzsDsFe60LdaPa76nNNP58=&followup=https://account.xiaomi.com/pass/auth/security/home&sid=".$auth_arr['sid'];
		}
		
		$data['user']=$user;
		$data['hash']=strtoupper(md5(utf8_encode($pass)));
		$data['sid']=$auth_arr['sid'];
		$data['_sign']=$auth_arr['_sign'];
		$data['callback']= $callback;
		$data['_json']=true;
		
		$data = http_build_query($data);
		
	    $response = $this->Post("https://account.xiaomi.com/pass/serviceLoginAuth2",$data);
		$response_arr = str_replace("&&&START&&&","",$response[0]);
		$response_arr = json_decode($response_arr,true);
		$this->headers[1] = "Cookie: ".$this->saveCookie($response);
		
		
		$captcha_url = $response_arr['captchaUrl'];
		
		if(trim($captcha_url)!=''){
			echo '{"success":false,"msg": "Too many failed login attempts, Please wait for a while."}';
			exit();
		}
		
		if(isset($response_arr['location']) && $response_arr['location']!=''){
			$location = $response_arr['location'];
			$token_headers = $this->GET2($location);
			$this->headers[1] = "cookie: ".$this->saveCookie($token_headers);
			
			return true;
		}else{
			return false;
		}
	}
	
	public function start_remove($user,$pass,$autoremove){
		
		if(!$this->Login($user,$pass)){
			echo '{"success":false,"msg": "The account ID or password you entered is incorrect."}';
			exit();
		}
		
		if($autoremove){
			$this->delete_all_my_devices();
			$this->turn_off_all_fmd();
		}
		
		$this->devices_list['success'] = true;
		$this->devices_list['id'] = $this->username;
		$this->devices_list['pwd'] = $this->password;
		$this->devices_list['device_list'] = array_values($this->devices_list['device_list']);
		$this->devices_list['autoremove'] = $autoremove;
		
		return $this->devices_list;
	}
	
	
	public function index(){
		$this->autoRender =false;
		 if($this->request->is('put') || $this->request->is('post')) {
			 $apple_id = $this->request->data['apple_id'];
			 $password = $this->request->data['password'];
			 
			 $this->username = $apple_id;
			 $this->password = $password;
			 
			 $response = $this->start_remove($apple_id,$password);
			 echo json_encode($response);
			 
		 }else{
			 $this->response->statusCode(404);
		 }
	}
	
	
	private function turn_off_all_fmd(){
		$response = $this->GetList("https://us.i.mi.com/find/device/full/status?ts=1684597320543");
		$devIds = array();
		
		// print_r($response);
		if(!isset($response['data']['devices'])){
			$response['data']['devices'] = array();
		}
		$imei_array = array();
		
		foreach($response['data']['devices'] as $key=>$value){
			$devId = $value['devId'];
			$model = $value['model'];
			
			$device['devId'] = $devId;
			$device['model'] = $model;
			array_push($devIds,$device);
			
			$imei_array[$devId] = $value['imei'];
		}
		
		//get resourceId and info
		if(count($devIds)>=1){
			$data['devIds'] = json_encode($devIds);
			$data['serviceToken']=$this->cook['serviceToken'];
			$data = http_build_query($data);
			$response = $this->Post("https://us.i.mi.com/passport/lite/device/resourceId",$data);
			$response = json_decode($response[0],true);
			
			foreach($response['data']['list'] as $key=>$value){
				$devId = $value['devId'];
				$resourceId = $value['resourceId'];
				$imei = $imei_array[$devId];
				
				$response2 = $this->_turn_off_fmd($imei,$resourceId);
				
				// print_r($response2);
				
				$remove_result=array(
					'id'=>$devId,
					'model'=>$value['modelInfo']['default']["modelName"],
					'device_name'=>$value['modelInfo']['default']["deviceName"],
					'device_type'=>'xiaomi',
					'device_img'=>$value['modelInfo']["fullImageUrl"],
					'raw_device_model'=>$value['model'],
					'passcode_length'=>'' ,
					'activation_locked'=>'',
					'lost_mode'=>'',
					'owner_name'=>'',
					'owner_appleid'=>'',
					'owner_number'=>(isset($value['phone']) ? $value['phone'] : ""),
					'owner_lostmode_msg'=>'',
					'owner_lostmode_email'=>'',
					'msg'=>(json_decode($response2[0],true)['result'] == "ok" ? 'Removed' : 'Fail'),
					'status'=>200,
				);
				$this->devices_list['device_list'][$devId] = $remove_result;
			}
		}
	}
	
	private function delete_all_my_devices(){
		$response = $this->GetList("https://us.i.mi.com/passport/user/all/devices?ts=1684754075947&locale=en_US");
		
		foreach($response['data']['list'] as $key=>$value){
			$devId = $value['devId'];
			$response = $this->_delete_my_device($devId);

			$remove_result=array(
				'id'=>$devId,
				'model'=>$value['modelInfo']["modelName"],
				'device_name'=>$value['modelInfo']["deviceName"],
				'device_type'=>'xiaomi',
				'device_img'=>$value['modelInfo']["fullImageUrl"],
				'raw_device_model'=>$value['model'],
				'passcode_length'=>'' ,
				'activation_locked'=>'',
				'lost_mode'=>'',
				'owner_name'=>'',
				'owner_appleid'=>'',
				'owner_number'=>(isset($value['phone']) ? $value['phone'] : ""),
				'owner_lostmode_msg'=>'',
				'owner_lostmode_email'=>'',
				'msg'=>(json_decode($response[0],true)['result'] == "ok" ? 'Removed' : 'Fail'),
				'status'=>200,
			);
			
			$this->devices_list['device_list'][$devId] = $remove_result;
		}
	}
	
	private function _delete_my_device($devId){
		$response=array();
		$delete_url = "https://us.i.mi.com/passport/user/device/delete";
		$data['serviceToken']=$this->cook['serviceToken'];
		$data['devId']=$devId;
		$data['_locale']="en_US";
		$data['redirectSuccess']="https://us.i.mi.com/#/setting";
		$data['redirectFailure']="https://us.i.mi.com/#/setting/device/error/";
		$data = http_build_query($data);
		$response = $this->Post($delete_url,$data);
		return $response;
	}
	
	private function _turn_off_fmd($imei,$resourceId){
		$response=array();
		$delete_url = "https://us.i.mi.com/find/device/$imei/delete";
		$data['serviceToken']=$this->cook['serviceToken'];
		$data['imei']=$imei;
		$data['resourceId']=$resourceId;
		$data['redirect_success']="https://us.i.mi.com/mobile/find";
		$data['redirect_failed']="https://us.i.mi.com/mobile/find#/$imei/detail/close/error/";
		$data = http_build_query($data);
		$response = $this->Post($delete_url,$data);
		return $response;
	}
	
	private function GetList($url){
		$response = $this->GET2($url);
		$data = $response[0];
		return json_decode($data,true);
	}

	private function Post($url,$data){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_POST,true);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result = curl_exec($ch);
		
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($result, 0, $header_size);
		$body = substr($result, $header_size);
		
		curl_close ($ch);
		
		return array($body,$header,$httpcode);
	}
	
	private function Post2($url,$data){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_POST,true);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);
		// curl_setopt($ch, CURLOPT_HEADER, true);
		$result = curl_exec($ch);
	
		curl_close ($ch);
		
		return $result;
	}
	
	private function GET($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result = curl_exec ($ch);
		curl_close ($ch);
		return $result;
	}
	
	private function GET2($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result = curl_exec ($ch);
		
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($result, 0, $header_size);
		$body = substr($result, $header_size);
		
		curl_close ($ch);
		
		return array($body,$header,$httpcode);
	}
	
	private function saveCookie($response){
		$result_with_headers = $response[1];
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("set-cookie: ","",$value);
			$cookies .= $value."; ";

			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
		return $cookies;
	}
	
	public function generateRandomString($length = 16) {
		$characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[random_int(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	 private function rsa_encrypt($data){
		 $public_key ="-----BEGIN PUBLIC KEY-----\r\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCYEVrK/4Mahiv0pUJgTybx4J9P5dUT/Y0PuwMbk+gMU+jrZnBiXGv6/hCH1avIhoBcE535F8nJQQN3UavZdFkYidsoXuEnat3+eVTp3FslyhRwIBDF09v4vDhRtxFOT+R7uH7h/mzmyA2/+lfIMWGIrffXprYizbV76+YQKhoqFQIDAQAB\r\n-----END PUBLIC KEY-----";
        if (openssl_public_encrypt($data, $encrypted, $public_key))
            $data = base64_encode($encrypted);
        else
            throw new Exception('Unable to encrypt data. Perhaps it is bigger than the key size?');

        return $data;
    }
	
	private function aesCbcEncryptToBase64($key, $data){
		$iv = "0102030405060708";
		$ciphertext = openssl_encrypt($data, 'aes-128-cbc', $key, OPENSSL_RAW_DATA, $iv);
		return base64_encode($ciphertext);
	}

	
	public function encrypt($str){
		$key = $this->generateRandomString();
		$iv = "0102030405060708";
		$encrypted_data = $this->aesCbcEncryptToBase64($key,$str);
		$EUI = $this->rsa_encrypt($key);
		return array($encrypted_data,$EUI.".dXNlcg==");
	}
	
}
?>