process.on('uncaughtException', function(er) {
	console.log(er);
});
process.on('unhandledRejection', function(er) {
	console.log(er);
});

const {
    firefox
} = require('playwright-extra');

const apple_id = process.argv[2];
const password = process.argv[3];
var has_response = false;

async function start() {
	 firefox.launch({
        headless: true,
        timeout: 10000,
        ignoreHTTPSErrors: true,
        args: [
            '--no-sandbox',
            '--disable-setuid-sandbox',
            '--disable-dev-shm-usage',
            '--disable-accelerated-2d-canvas',
            '--no-first-run',
            '--no-zygote',
            '--single-process', // <- this one doesn't work on Windows
            '--disable-gpu'
        ]
    }).then(async browser => {
		const context = await browser.newContext({ timeout: 10000 })
		const page = await context.newPage()
        await page.setViewportSize({
            width: 500,
            height: 500
        });
		await page.setDefaultNavigationTimeout(30000);

		 try {
			
			await page.route("https://www.google.com/android/find/?access_token**", route => {
			  route.continue();
			});
			
			page.on('response', async (response) => {
			  const responseUrl = response.url();
			  if (responseUrl.includes('/accountlookup?')) {
				var response_json = await response.text();
				response_json = response_json.replace(')]}\'','').replace(/\n/g,'');
				response_json = JSON.parse(response_json);
				
				if(response_json[0][1].length < 3){
					has_response = true;
					console.log('{"success": false, "msg": "Invalid email or phone number."}');
					await browser.close();
				}
				
			  }
			});
			
			
            await page.goto('https://www.google.com/android/find/');

			var signinbtn = page.locator("#identifierNext button");
			await signinbtn.waitFor({state: "visible"});
			
			var input_email = page.locator('input[type="email"]');
			input_email.fill(apple_id);
			await signinbtn.click();
			
			await page.waitForLoadState('networkidle');
			
			signinbtn = page.locator("#passwordNext button");
			await signinbtn.waitFor({state: "visible"});
			
			var input_password = page.locator('input[name="password"]');
			await input_password.waitFor({state: "visible"});
			input_password.fill(password);
			await signinbtn.click();
			
			// await new Promise(resolve => setTimeout(resolve, 2000));
			// await page.waitForLoadState('networkidle');
			// const currentUrl = await page.url();
			// console.log(currentUrl);
			
			page.on('response', async (response) => {
			  const responseUrl = response.url();
			  if (responseUrl.includes('signin/challenge')) {
				var response_json = await response.text();
				
				response_json = response_json.replace(')]}\'','').replace(/\n/g,'');
				data = JSON.parse(response_json);

				if(data[0][0].length < 14){
					console.log('{"success": false, "msg": "Invalid Password."}');
					await browser.close();
				}
			  }
			});
			

			page.on('request', async (request) => {
			  const requestUrl = request.url();
			  if (requestUrl.includes('android/find/?access_token=')) {
					url = request.url();
					// console.log("{success: true, msg: '" + url + "'}");
					// await browser.close();
			  }
			});
			
			page.on('response', async (response) => {
			  const responseUrl = response.url();
			  if (responseUrl.includes('BoqWebFindMyDeviceUi/data/batchexecute')) {
				var response_json = await response.text();
				
				response_json = response_json.replace(')]}\'','').replace(/\n/g,'');
				data = JSON.stringify(response_json);
				
				console.log('{"success": true, "msg": "' + url + '", "raw_data": "' + encodeURI(data) + '"}');
				await browser.close();
				
			  }
			});
			
	
        } catch (error1) {
			if(has_response == false){
				await browser.close();
				console.log('{"success": false, "msg": "' + error1.message + '"}');
			}
        }

	});
}

start();